/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.task;

import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.task.PmTaskPortalLifeCycleEvent;
import com.ibm.hwmca.fw.servlet.pmod.task.PmTaskPortalLifeCycleListener;
import com.ibm.hwmca.fw.servlet.pmod.task.PmTaskPortalLifeCycleTerminationEvent;
import com.ibm.hwmca.fw.servlet.pmod.task.PmTaskPortalPanelStackEvent;
import com.ibm.hwmca.fw.servlet.pmod.task.TaskEndedException;
import com.ibm.hwmca.fw.servlet.pmod.util.BlockingValve;
import com.ibm.hwmca.fw.servlet.taskcontroller.TaskControllerQueue;
import com.ibm.hwmca.fw.servlet.tasks.ContentManager;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.TaskWindowPositionManager;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.util.NamedTimer;
import com.ibm.hwmca.fw.util.Trace;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;

public class PanelModelTaskPortal {
    private static final String TRACE_MASKT = "XPMTPORT";
    private static final String TRACE_MASKF = "XPMTPORF";
    private static final String TRACE_MASKD = "XPMTPORD";
    private static final EventHandler terminateEventHandler = new EventHandler(){

        public void handle(PmTaskPortalLifeCycleListener listener, PmTaskPortalLifeCycleEvent event) {
            listener.taskTermination(event);
        }

        public String toString() {
            return "'terminate' handler";
        }
    };
    private static final EventHandler modelEnqueueEventHandler = new EventHandler(){

        public void handle(PmTaskPortalLifeCycleListener listener, PmTaskPortalLifeCycleEvent event) {
            listener.modelEnQueued((PmTaskPortalPanelStackEvent)event);
        }

        public String toString() {
            return "'enqueue model' handler";
        }
    };
    private static final EventHandler modelDequeueEventHandler = new EventHandler(){

        public void handle(PmTaskPortalLifeCycleListener listener, PmTaskPortalLifeCycleEvent event) {
            listener.modelDeQueued((PmTaskPortalPanelStackEvent)event);
        }

        public String toString() {
            return "'dequeue model' handler";
        }
    };
    public static final ThreadGroup portalThreadGroup = new ThreadGroup("PanelModelTaskPortal Thread Group");
    private static final int EMPTY_STACK_DELAY = 2000;
    private static final int REFRESH_WINDOW = 6000;
    private static final int NEVER = -1;
    private static final Dimension DEFAULT_WINDOW_DIMENSION;
    private static int instanceCount;
    private static Timer timer;
    private ArrayList lcListeners = new ArrayList();
    private LiteStack modelStack = new LiteStack();
    private Object stackLock = new Object();
    private PresentationTask presentationTask = null;
    private HMCSession hmcSession = null;
    private boolean taskEnded = false;
    private String taskId = null;
    private Map attributes = null;
    private boolean taskInterfaceActive = false;
    private String traceId = "PanelModelTaskPortal(id=" + this.getNextTraceId() + ")";
    private boolean refreshEnabled = true;
    private boolean embeddedTask = false;
    private String redirectURL = null;
    private String windowName = null;
    private boolean blockTriggerThread = false;
    private Object triggerLock = new Object();
    private int triggerThreadInvocationCount = 0;
    private boolean windowOpen = false;
    private RefreshTask refreshTask = null;
    private long lastRefresh = -1L;
    private int modificationLevel = 0;
    private BlockingValve triggerManagerThreadBlockingValve = null;
    private boolean realized = false;
    private Set additionalWindowNames;
    private Object additionalWindowNamesLock = new Object();

    private synchronized String getNextTraceId() {
        return Integer.toString(instanceCount++);
    }

    public PanelModelTaskPortal(PresentationTask presentationTask, HMCSession hmcSession) {
        Trace.trace(TRACE_MASKF, this.traceId + " <ctor>.");
        this.presentationTask = presentationTask;
        this.hmcSession = hmcSession;
    }

    public PanelModelTaskPortal(PresentationTask presentationTask, HMCSession hmcSession, boolean refreshEnabled) {
        this(presentationTask, hmcSession);
        this.setRefreshEnabled(refreshEnabled);
    }

    public void setTriggerManagerThreadBlockingValve(BlockingValve triggerManagerThreadBlockingValve) {
        this.triggerManagerThreadBlockingValve = triggerManagerThreadBlockingValve;
    }

    public int getModificationLevel() {
        return this.modificationLevel;
    }

    public void taskStarted() {
        this.associatePortalWithCurrentThread();
    }

    public void requestFocus() {
        Trace.trace(TRACE_MASKF, this.traceId + ".requestFocus()");
        final PanelModel model = (PanelModel)this.modelStack.peek();
        if (model != null) {
            new Thread("Portal FocusRequest() service thread"){

                public void run() {
                    model.getImplAccess().requestFocus();
                }
            }.start();
        } else {
            Trace.trace(TRACE_MASKF, "WARNING: No models on stack, ignored!");
        }
    }

    public void setWindowOpen(boolean windowOpen) {
        Trace.trace(TRACE_MASKF, this.traceId + ".setWindowOpen(" + windowOpen + ")");
        if (this.windowOpen == windowOpen) {
            return;
        }
        this.windowOpen = windowOpen;
        if (windowOpen) {
            this.hmcSession.fireWindowOpenedEvent(this, this.windowName);
        } else {
            this.hmcSession.fireWindowClosedEvent(this, this.windowName);
        }
    }

    public boolean isWindowOpen() {
        return this.windowOpen;
    }

    public void setWindowName(String windowName) {
        Trace.trace(TRACE_MASKF, this.traceId + ".setWindowName(" + windowName + ")");
        this.windowName = windowName;
    }

    public String getWindowName() {
        return this.windowName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdditionalWindowName(String windowName) {
        Object object = this.additionalWindowNamesLock;
        synchronized (object) {
            Trace.trace(TRACE_MASKF, this.traceId + ".addAdditionalWindowName(" + windowName + ")");
            if (this.additionalWindowNames == null) {
                this.additionalWindowNames = new TreeSet();
            }
            this.additionalWindowNames.add(windowName);
        }
        this.hmcSession.fireWindowOpenedEvent(this, windowName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdditionalWindowName(String windowName) {
        Object object = this.additionalWindowNamesLock;
        synchronized (object) {
            Trace.trace(TRACE_MASKF, this.traceId + ".removeAdditionalWindowName(" + windowName + ")");
            if (this.additionalWindowNames == null) {
                return;
            }
            this.additionalWindowNames.remove(windowName);
        }
        this.hmcSession.fireWindowClosedEvent(this, windowName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAdditionalWindowNames() {
        Object object = this.additionalWindowNamesLock;
        synchronized (object) {
            if (this.additionalWindowNames == null) {
                return Collections.EMPTY_SET;
            }
            Trace.trace(TRACE_MASKF, this.traceId + ".getAdditionalWindowName()");
            return new TreeSet(this.additionalWindowNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closingAllAdditionalWindows() {
        ArrayList windowNames = null;
        Object object = this.additionalWindowNamesLock;
        synchronized (object) {
            if (this.additionalWindowNames == null) {
                return;
            }
            windowNames = new ArrayList(this.additionalWindowNames);
            this.additionalWindowNames.clear();
        }
        Iterator iterator = windowNames.iterator();
        while (iterator.hasNext()) {
            String windowName = (String)iterator.next();
            this.hmcSession.fireWindowClosedEvent(this, windowName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAdditionalWindows() {
        Trace.trace(TRACE_MASKT, this.traceId + ".closeAdditionalWindows()");
        TaskControllerQueue queue = TaskControllerQueue.getTaskControllerQueue(this.hmcSession);
        if (queue == null) {
            return;
        }
        StringBuffer script = new StringBuffer();
        ArrayList windowNames = null;
        Object object = this.additionalWindowNamesLock;
        synchronized (object) {
            if (this.additionalWindowNames.isEmpty()) {
                return;
            }
            windowNames = new ArrayList(this.additionalWindowNames);
            Iterator iterator = this.additionalWindowNames.iterator();
            while (iterator.hasNext()) {
                String windowName = (String)iterator.next();
                script.append("try {additionalWin=window.open('");
                script.append(windowName);
                script.append("'); if (additionalWin!=null) additionalWin.close();} catch (e) {}\n");
                iterator.remove();
            }
        }
        queue.sendScript(script.toString());
        Iterator iterator = windowNames.iterator();
        while (iterator.hasNext()) {
            String windowName = (String)iterator.next();
            this.hmcSession.fireWindowClosedEvent(this, windowName);
        }
    }

    public boolean isTaskInterfaceActive() {
        return this.taskInterfaceActive;
    }

    public boolean isEmbedded() {
        return this.embeddedTask;
    }

    public void setEmbedded(boolean embedded) {
        this.embeddedTask = embedded;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public void setRefreshEnabled(boolean refreshEnabled) {
        Trace.trace(TRACE_MASKF, this.traceId + ".refreshEnabled(" + refreshEnabled + ")");
        this.refreshEnabled = refreshEnabled;
    }

    public void windowClosed() {
        Trace.trace(TRACE_MASKF, this.traceId + ".windowClosed()");
        this.setWindowOpen(false);
        final PanelModel model = (PanelModel)this.modelStack.peek();
        if (model != null) {
            new Thread("Portal WindowClosed() service thread"){

                public void run() {
                    model.getImplAccess().windowClosed();
                }
            }.start();
        }
    }

    public boolean isRefreshEnabled() {
        return this.refreshEnabled;
    }

    public synchronized Object getAttribute(Object key) {
        Trace.trace(TRACE_MASKF, this.traceId + ".getAttribute(" + key + ")");
        return this.attributes == null ? null : this.attributes.get(key);
    }

    public synchronized void setAttribute(Object key, Object value) {
        Trace.trace(TRACE_MASKF, this.traceId + ".setAttribute(" + key + "," + value + ")");
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(key, value);
    }

    public synchronized Object removeAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(key);
    }

    public void setTaskId(String taskId) {
        Trace.trace(TRACE_MASKF, this.traceId + ".setTaskId(" + taskId + ")");
        this.taskId = taskId;
        if (this.windowName == null && taskId != null) {
            this.setWindowName(this.getHMCSession().getWindowPrefix() + "task".concat(taskId));
        }
    }

    public String getTaskId() {
        Trace.trace(TRACE_MASKF, this.traceId + ".getTaskId()");
        return this.taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preTriggerManager(PanelModel theModel) throws TaskEndedException {
        Trace.trace(TRACE_MASKF, this.traceId + ".preTriggerManager('" + theModel + "')");
        this.taskInterfaceActive = true;
        this.associatePortalWithCurrentThread();
        PanelModel model = null;
        Object object = this.stackLock;
        synchronized (object) {
            if (this.taskEnded) {
                Trace.trace(TRACE_MASKT, this.traceId + ": task has ended.");
                throw new TaskEndedException("The task has ended.");
            }
            if (this.modelStack.isEmpty()) {
                Trace.trace(TRACE_MASKT, this.traceId + ": WARNING model stack is empty!, ignoring invocation.");
                return;
            }
            if (this.modelStack.peek() != theModel) {
                Trace.trace(TRACE_MASKT, this.traceId + ": WARNING top model not equal to provided model, ignoring invocation.");
                return;
            }
            model = (PanelModel)this.modelStack.peek();
        }
        model.getImplAccess().getWclEventProxyManager().preTriggerManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void failedTriggerManager(PanelModel theModel) {
        Trace.trace("XPMTPORF", this.traceId + ".failedTriggerManager('" + theModel + "')");
        model = null;
        var3_3 = this.stackLock;
        synchronized (var3_3) {
            if (this.taskEnded) break block10;
            if (this.modelStack.isEmpty()) {
                Trace.trace("XPMTPORT", this.traceId + ": WARNING model stack is empty!, ignoring invocation.");
                // MONITOREXIT @DISABLED, blocks:[0, 5, 9] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                this.taskInterfaceActive = false;
                return;
            }
            if (this.modelStack.peek() == theModel) ** break block11
        }
        {
            Trace.trace("XPMTPORT", this.traceId + ": WARNING top model not equal to provided model, ignoring invocation.");
        }
        this.taskInterfaceActive = false;
        return;
        {
            block12: {
                block10: {
                    ** try [egrp 3[TRYBLOCK] [6 : 143->240)] { 
lbl21:
                    // 1 sources

                    model = (PanelModel)this.modelStack.peek();
                    break block12;
                }
                Trace.trace("XPMTPORT", this.traceId + ": task has ended, ignored.");
            }
            ** if (model == null) goto lbl29
        }
lbl-1000:
        // 1 sources

        {
            model.getImplAccess().getWclEventProxyManager().failedTriggerManager();
            return;
        }
lbl29:
        // 1 sources

        Trace.trace("XPMTPORT", this.traceId + ": WARNING unable to obtain model, ignoring invocation.");
        return;
lbl-1000:
        // 1 sources

        {
            finally {
                this.taskInterfaceActive = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void postTriggerManager(PanelModel theModel) throws TaskEndedException {
        PanelModel activeModel;
        block15: {
            Trace.trace(TRACE_MASKF, this.traceId + ".postTriggerManager('" + theModel + "')");
            this.traceStackState("postTriggerManager() method entry");
            activeModel = theModel;
            Object object = this.stackLock;
            // MONITORENTER : object
            if (this.taskEnded) {
                Trace.trace(TRACE_MASKT, this.traceId + ": task has ended.");
                throw new TaskEndedException("The task has ended.");
            }
            if (this.modelStack.isEmpty()) {
                Trace.trace(TRACE_MASKT, this.traceId + ": WARNING model stack is empty!, ignoring invocation.");
                // MONITOREXIT : object
                this.taskInterfaceActive = false;
                return;
            }
            if (this.modelStack.peek() == activeModel) break block15;
            Trace.trace(TRACE_MASKT, this.traceId + ": WARNING top model not equal to provided model, ignoring invocation.");
            // MONITOREXIT : object
            this.taskInterfaceActive = false;
            return;
        }
        try {
            // MONITOREXIT : object
            PortalEventThread eventThread = new PortalEventThread(activeModel, ++this.triggerThreadInvocationCount);
            activeModel.getImplAccess().setPortalMeta(eventThread);
            eventThread.setDaemon(true);
            this.blockTriggerThread = true;
            eventThread.start();
            Trace.trace(TRACE_MASKF, this.traceId + " blocking trigger manager thread (waiting for event thread).");
            Object object = this.triggerLock;
            // MONITORENTER : object
            while (this.blockTriggerThread) {
                try {
                    this.triggerLock.wait();
                }
                catch (InterruptedException e) {}
            }
            // MONITOREXIT : object
            Trace.trace(TRACE_MASKF, this.traceId + " trigger manager thread released.");
            eventThread.throwAnyExceptions();
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.taskInterfaceActive = false;
        }
        Trace.trace(TRACE_MASKF, this.traceId + ".postTriggerManager('" + theModel + "') returning");
    }

    public HMCSession getHMCSession() {
        Trace.trace(TRACE_MASKF, this.traceId + ".getHMCSession()");
        return this.hmcSession;
    }

    public ContentManager getContentManager() {
        Trace.trace(TRACE_MASKF, this.traceId + ".getContentManager()");
        return ContentManager.getContentManager(this.hmcSession);
    }

    public void associatePortalWithCurrentThread() {
        Trace.trace(TRACE_MASKF, this.traceId + ".associatePortalWithCurrentThread()");
        PanelModel.setThreadLocalPanelModelTaskPortal(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PanelModel getCurrentPanelModel(boolean stabilize) throws TaskEndedException {
        Trace.trace(TRACE_MASKF, this.traceId + ".getCurrentPanelModel('" + stabilize + "')");
        if (stabilize && this.modelStack.isEmpty()) {
            long stopTime = System.currentTimeMillis() + 2000L;
            long toWait = 2000L;
            Object object = this.stackLock;
            synchronized (object) {
                while (!this.taskEnded && this.modelStack.isEmpty() && toWait > 0L) {
                    try {
                        this.stackLock.wait(toWait);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    toWait = stopTime - System.currentTimeMillis();
                }
            }
        }
        return this.stabilizeStack(stabilize);
    }

    public PanelModel getCurrentPanelModel() throws TaskEndedException {
        Trace.trace(TRACE_MASKF, this.traceId + ".getCurrentPanelModel()");
        return this.getCurrentPanelModel(true);
    }

    public PanelModel getCurrentPanelModelAndLock() throws TaskEndedException {
        Trace.trace(TRACE_MASKF, this.traceId + ".getCurrentPanelModelAndLock()");
        return this.getCurrentPanelModelAndLock(true);
    }

    private PanelModel getCurrentPanelModelAndLock(boolean stabilize) throws TaskEndedException {
        Trace.trace(TRACE_MASKF, this.traceId + ".getCurrentPanelModelAndLock('" + stabilize + "')");
        PanelModel candidate = this.getCurrentPanelModel(stabilize);
        while (candidate != null) {
            candidate.getImplAccess().obtainTransactionLock();
            if (!candidate.getImplAccess().isDisposed()) break;
            candidate.getImplAccess().releaseTransactionLock();
            PanelModel newCandidate = this.getCurrentPanelModel(stabilize);
            if (candidate == newCandidate) {
                throw new RuntimeException("Some how refetched the same 'disposed' PanelModel from the stack!");
            }
            candidate = newCandidate;
        }
        return candidate;
    }

    public Dimension getWindowSize() {
        PanelModel model = (PanelModel)this.modelStack.peek();
        if (model != null) {
            return model.getImplAccess().getWindowSize();
        }
        return DEFAULT_WINDOW_DIMENSION;
    }

    public TaskWindowPositionManager.WindowPosition getWindowPosition() {
        return TaskWindowPositionManager.getTaskWindowPositionManager(this.hmcSession).getWindowPosition(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PanelModel stabilizeStack(boolean stabilize) throws TaskEndedException {
        Trace.trace(TRACE_MASKF, this.traceId + ".stabilizeStack()");
        Object object = this.stackLock;
        synchronized (object) {
            while (true) {
                if (this.taskEnded) {
                    // MONITOREXIT @DISABLED, blocks:[2, 4, 7] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                    Trace.trace(TRACE_MASKT, this.traceId + ": task has ended.");
                    throw new TaskEndedException("The task has ended.");
                }
                PanelModel model = (PanelModel)this.modelStack.peek();
                if (model == null) {
                    Trace.trace(TRACE_MASKF, this.traceId + ".stabilizeStack() model was null, returning.");
                    return null;
                }
                try {
                    PortalEventThread pet = (PortalEventThread)model.getImplAccess().getPortalMeta();
                    if (stabilize && pet != null && pet.isThreadRunning()) {
                        Trace.trace(TRACE_MASKF, this.traceId + ".stabilizeStack() blocks in a wait....");
                        this.stackLock.wait();
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, this.traceId + ".stabilizeStack() returns model without blocking.");
                    return model;
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateTask() {
        Trace.trace(TRACE_MASKF, this.traceId + ".terminateTask()");
        if (!this.taskEnded) {
            boolean mustCloseAdditionalWindows = false;
            Object object = this.stackLock;
            synchronized (object) {
                if (this.modelStack.isEmpty() && this.additionalWindowNames != null && !this.additionalWindowNames.isEmpty()) {
                    mustCloseAdditionalWindows = true;
                }
            }
            while (true) {
                PanelModel top;
                Object object2 = this.stackLock;
                synchronized (object2) {
                    top = (PanelModel)this.modelStack.peek();
                }
                if (top == null) break;
                top.dispose();
            }
            object = this.stackLock;
            synchronized (object) {
                this.taskEnded = true;
                this.stackLock.notifyAll();
            }
            if (mustCloseAdditionalWindows) {
                this.closeAdditionalWindows();
            }
            this.fireEvent(terminateEventHandler, new PmTaskPortalLifeCycleTerminationEvent(this));
        } else {
            Trace.trace(TRACE_MASKT, this.traceId + ": task has ended, ignored.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushModel(PanelModel model) throws TaskEndedException {
        Trace.trace(TRACE_MASKF, this.traceId + ".pushModel(" + model + ")");
        this.traceStackState("pushModel() method entry");
        Object object = this.stackLock;
        synchronized (object) {
            try {
                if (this.taskEnded) {
                    Trace.trace(TRACE_MASKT, this.traceId + ": task has ended.");
                    throw new TaskEndedException("The task has ended.");
                }
                if (this.isOnStack(model)) {
                    String msg = "Model stack already contains specified model.";
                    Trace.trace(TRACE_MASKT, this.traceId + ": ".concat(msg));
                    throw new RuntimeException(msg);
                }
                Trace.trace(TRACE_MASKF, this.traceId + ": pushes model: " + model);
                this.modelStack.push(model);
                this.traceStackState("Model was pushed, stack now looks like");
            }
            finally {
                this.stackLock.notifyAll();
            }
        }
        this.fireEvent(modelEnqueueEventHandler, new PmTaskPortalPanelStackEvent(this, model));
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popModel() throws TaskEndedException {
        Trace.trace(TRACE_MASKF, this.traceId + ".popModel()");
        this.traceStackState("popModel() method entry");
        PanelModel model = null;
        Object object = this.stackLock;
        synchronized (object) {
            try {
                if (this.taskEnded) {
                    Trace.trace(TRACE_MASKT, this.traceId + ": task has ended.");
                    throw new TaskEndedException("The task has ended.");
                }
                model = (PanelModel)this.modelStack.pop();
                Trace.trace(TRACE_MASKF, this.traceId + ": pops model: " + model);
            }
            finally {
                this.stackLock.notifyAll();
            }
        }
        if (model != null) {
            this.fireEvent(modelDequeueEventHandler, new PmTaskPortalPanelStackEvent(this, model));
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModel(PanelModel model) throws TaskEndedException {
        Trace.trace(TRACE_MASKF, this.traceId + ".removeModel('" + model + "')");
        this.traceStackState("removeModel() method entry");
        boolean refreshNeeded = false;
        boolean removed = false;
        Object object = this.stackLock;
        synchronized (object) {
            try {
                if (this.taskEnded) {
                    Trace.trace(TRACE_MASKT, this.traceId + ": task has ended.");
                    throw new TaskEndedException("The task has ended.");
                }
                refreshNeeded = this.modelStack.contains(model) && this.modelStack.peek() == model;
                removed = this.modelStack.remove(model);
                Trace.trace(TRACE_MASKF, this.traceId + ": removing model: " + model);
            }
            finally {
                this.stackLock.notifyAll();
            }
        }
        if (removed) {
            this.fireEvent(modelDequeueEventHandler, new PmTaskPortalPanelStackEvent(this, model));
        }
        if (refreshNeeded) {
            this.refresh();
        }
    }

    public boolean isPanelStackEmpty() throws TaskEndedException {
        Trace.trace(TRACE_MASKF, this.traceId + ".isPanelStackEmtpy()");
        if (this.taskEnded) {
            Trace.trace(TRACE_MASKT, this.traceId + ": task has ended.");
            throw new TaskEndedException("The task has ended.");
        }
        return this.modelStack.isEmpty();
    }

    public boolean isOnStack(PanelModel model) throws TaskEndedException {
        Trace.trace(TRACE_MASKF, this.traceId + ".isOnStack(" + model + ")");
        if (this.taskEnded) {
            Trace.trace(TRACE_MASKT, this.traceId + ": task has ended.");
            throw new TaskEndedException("The task has ended.");
        }
        return this.modelStack.contains(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOnStackTop(PanelModel model) throws TaskEndedException {
        Trace.trace(TRACE_MASKF, this.traceId + ".isOnStackTop(" + model + ")");
        Object object = this.stackLock;
        synchronized (object) {
            if (this.taskEnded) {
                Trace.trace(TRACE_MASKT, this.traceId + ": task has ended.");
                throw new TaskEndedException("The task has ended.");
            }
            return !this.modelStack.isEmpty() && this.modelStack.peek() == model;
        }
    }

    public boolean isTaskEnded() {
        return this.taskEnded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPanel() {
        Object object = this.stackLock;
        synchronized (object) {
            while (!this.taskEnded && this.modelStack.isEmpty()) {
                try {
                    this.stackLock.wait();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTriggerManagerThread() {
        Trace.trace(TRACE_MASKF, this.traceId + ".releaseTriggerManagerThread().");
        Object object = this.triggerLock;
        synchronized (object) {
            this.blockTriggerThread = false;
            this.triggerLock.notifyAll();
        }
    }

    public void realized() {
        if (!this.realized) {
            this.realized = true;
            this.hmcSession.taskIsRealized(this);
        }
    }

    public void refresh() {
        this.refresh(null, false);
    }

    public void refresh(boolean giveFocus) {
        this.refresh(null, giveFocus);
    }

    public void refresh(PanelModel initiator) {
        this.refresh(initiator, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(PanelModel initiator, boolean giveFocus) {
        block22: {
            Trace.trace(TRACE_MASKF, this.traceId + ".refresh('" + initiator + "', " + giveFocus + ")");
            try {
                if (this.refreshEnabled) {
                    PanelModel topGuy = this.getCurrentPanelModelAndLock(false);
                    if (topGuy != null) {
                        try {
                            Object object = this.stackLock;
                            synchronized (object) {
                                if (initiator == null || topGuy == initiator) {
                                    if (topGuy.getImplAccess().isRendered()) {
                                        if (!this.taskInterfaceActive || giveFocus) {
                                            if (!topGuy.getImplAccess().isSerializationInProgress() || giveFocus) {
                                                this.driveRefresh(giveFocus);
                                            } else {
                                                Trace.trace(TRACE_MASKF, this.traceId + ".refresh() suppressing refresh, " + "top most PM is undergoing serialization.");
                                            }
                                        } else {
                                            Trace.trace(TRACE_MASKF, this.traceId + ".refresh() suppressing refresh, " + "TaskInterfaceServlet appears active.");
                                        }
                                    } else {
                                        Trace.trace(TRACE_MASKF, this.traceId + ".refresh() suppressing refresh, " + "panel not yet 'rendered'.");
                                    }
                                } else {
                                    Trace.trace(TRACE_MASKF, this.traceId + ".refresh() suppressing refresh, " + "initiator not null or doesn't match topmost PM on stack.");
                                }
                                break block22;
                            }
                        }
                        finally {
                            topGuy.getImplAccess().releaseTransactionLock();
                        }
                    }
                    if (!this.taskInterfaceActive) {
                        if (this.windowOpen) {
                            Trace.trace(TRACE_MASKF, this.traceId + ".refresh() model stack empty, " + "but window is open.");
                            this.driveRefresh(giveFocus);
                        } else {
                            Trace.trace(TRACE_MASKF, this.traceId + ".refresh() suppressing refresh, " + "model stack is empty & window is closed.");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, this.traceId + ".refresh() suppressing refresh, " + "model stack is empty but task interface is active.");
                    }
                    break block22;
                }
                Trace.trace(TRACE_MASKF, this.traceId + ".refresh() suppressing refresh, " + "task portal is not currently refresh enabled.");
            }
            catch (TaskEndedException e) {
                Trace.trace(TRACE_MASKF, this.traceId + ".refresh() suppressing refresh, " + "task appears to have ended.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void driveRefresh(boolean giveFocus) {
        block18: {
            TaskControllerQueue queue = TaskControllerQueue.getTaskControllerQueue(this.hmcSession);
            if (queue == null) {
                Trace.trace(TRACE_MASKT, this.traceId + ".driveRefresh() suppressing refresh, " + "unable to locate TaskControllerQueue.");
                return;
            }
            PanelModelTaskPortal panelModelTaskPortal = this;
            synchronized (panelModelTaskPortal) {
                long timeSinceLastRefresh;
                block17: {
                    Trace.trace(TRACE_MASKF, this.traceId + ".driveRefresh(" + giveFocus + ")");
                    if (!giveFocus && this.lastRefresh != -1L && (timeSinceLastRefresh = System.currentTimeMillis() - this.lastRefresh) <= 6000L) break block17;
                    try {
                        Trace.trace(TRACE_MASKF, this.traceId + ".driveRefresh() issues refresh to TaskControllerQueue. Giving focus==" + giveFocus);
                        queue.refresh(this, giveFocus);
                        Object var7_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        this.lastRefresh = System.currentTimeMillis();
                        if (this.refreshTask != null) {
                            try {
                                this.refreshTask.cancel();
                            }
                            catch (Exception e) {
                            }
                            finally {
                                this.refreshTask = null;
                            }
                        }
                        throw throwable;
                    }
                    this.lastRefresh = System.currentTimeMillis();
                    if (this.refreshTask != null) {
                        try {
                            this.refreshTask.cancel();
                        }
                        catch (Exception e) {
                        }
                        finally {
                            this.refreshTask = null;
                        }
                    }
                    break block18;
                }
                Trace.trace(TRACE_MASKF, this.traceId + ".driveRefresh() suppressing refresh, " + "a refresh was issued " + timeSinceLastRefresh + "ms ago (refresh window is " + 6000 + "ms).");
            }
        }
    }

    public synchronized void refresh(PanelModel initiator, int delay) {
        Trace.trace(TRACE_MASKF, this.traceId + ".refresh('" + initiator + "', " + delay + ")");
        if (this.refreshTask == null) {
            Trace.trace(TRACE_MASKF, this.traceId + " No refesh currently scheduled, so we'll schedule a refresh task.");
            this.refreshTask = new RefreshTask();
            this.refreshTask.schedule(initiator, delay);
        } else {
            long whenRequested = System.currentTimeMillis() + (long)delay;
            if (this.refreshTask.scheduledExecutionTime() > whenRequested) {
                Trace.trace(TRACE_MASKF, this.traceId + " Requested delay is closer than currently scheduled refresh task, we're moving it in.");
                this.refreshTask.cancel();
                this.refreshTask = new RefreshTask();
                this.refreshTask.schedule(initiator, delay);
            } else {
                Trace.trace(TRACE_MASKF, this.traceId + " Requested delay is beyond a currently scheduled refresh task, we ignore.");
            }
        }
    }

    public synchronized void acknowledgeRefreshes() {
        Trace.trace(TRACE_MASKF, this.traceId + ".acknowledgeRefreshes().  Resetting refresh window.");
        this.lastRefresh = -1L;
        if (this.refreshTask != null) {
            this.refreshTask.cancel();
            this.refreshTask = null;
        }
    }

    private synchronized void fireEvent(EventHandler handler, PmTaskPortalLifeCycleEvent event) {
        Trace.trace(TRACE_MASKF, this.traceId + ".fireEvent(" + handler + ", " + event + ")");
        List cloned = (List)this.lcListeners.clone();
        Iterator iterator = cloned.iterator();
        while (iterator.hasNext()) {
            handler.handle((PmTaskPortalLifeCycleListener)iterator.next(), event);
        }
    }

    public synchronized void addLifeCycleListener(PmTaskPortalLifeCycleListener listener) {
        Trace.trace(TRACE_MASKF, this.traceId + ".addLifeCycleListener(" + listener + ")");
        if (!this.lcListeners.contains(listener)) {
            this.lcListeners.add(listener);
        }
    }

    public synchronized void removeLifeCycleListener(PmTaskPortalLifeCycleListener listener) {
        Trace.trace(TRACE_MASKF, this.traceId + ".removeLifeCycleListener(" + listener + ")");
        if (!this.lcListeners.contains(listener)) {
            this.lcListeners.remove(listener);
        }
    }

    public PresentationTask getPresentationTask() {
        return this.presentationTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceStackState(String msg) {
        Trace.trace(TRACE_MASKF, this.traceId + ".traceStackState() '" + msg + "'");
        Object object = this.stackLock;
        synchronized (object) {
            Iterator iterator = this.modelStack.iterator();
            while (iterator.hasNext()) {
                Trace.trace(TRACE_MASKF, "\t" + iterator.next());
            }
        }
        Trace.trace(TRACE_MASKF, this.traceId + ".traceStackState() completes");
    }

    public String toString() {
        return this.traceId;
    }

    static {
        portalThreadGroup.setDaemon(false);
        DEFAULT_WINDOW_DIMENSION = new Dimension(500, 500);
        timer = new NamedTimer(true, "PM-TaskPortal Timer");
    }

    private class LiteStack
    extends ArrayList {
        private LiteStack() {
        }

        public Object peek() {
            if (this.isEmpty()) {
                return null;
            }
            return this.get(this.size() - 1);
        }

        public void push(Object newGuy) {
            PanelModelTaskPortal.this.modificationLevel++;
            this.add(newGuy);
        }

        public Object pop() {
            if (this.isEmpty()) {
                return null;
            }
            PanelModelTaskPortal.this.modificationLevel++;
            return this.remove(this.size() - 1);
        }
    }

    private class PortalEventThread
    extends Thread {
        private PanelModel activeModel = null;
        private boolean threadRunning = true;
        private int count = 0;
        private Exception pendingException = null;

        public PortalEventThread(PanelModel activeModel, int count) {
            super(portalThreadGroup, "PortalEventThread");
            this.activeModel = activeModel;
            this.count = count;
        }

        public void throwAnyExceptions() throws RuntimeException {
            if (this.pendingException != null) {
                throw new RuntimeException("Exception caught by event thread.", this.pendingException);
            }
        }

        public boolean isThreadRunning() {
            Trace.trace(PanelModelTaskPortal.TRACE_MASKF, PanelModelTaskPortal.this.traceId + " EventThread ('" + this + "') isThreadRunning() (will return '" + this.threadRunning + "') ");
            return this.threadRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Trace.trace(PanelModelTaskPortal.TRACE_MASKF, PanelModelTaskPortal.this.traceId + " EventThread begins running (activeModel='" + this.activeModel + "').");
                try {
                    Trace.trace(PanelModelTaskPortal.TRACE_MASKF, PanelModelTaskPortal.this.traceId + " EventThread calling to wcl proxy object to handle events.");
                    this.activeModel.getImplAccess().getWclEventProxyManager().postTriggerManager();
                    Trace.trace(PanelModelTaskPortal.TRACE_MASKF, PanelModelTaskPortal.this.traceId + " EventThread return from call to wcl proxy object, normally.");
                }
                catch (Exception exception) {
                    Trace.trace(PanelModelTaskPortal.TRACE_MASKF, PanelModelTaskPortal.this.traceId + " EventThread return from call to wcl proxy object, exception path.");
                    this.pendingException = exception;
                }
                if (PanelModelTaskPortal.this.triggerManagerThreadBlockingValve != null) {
                    try {
                        Trace.trace(PanelModelTaskPortal.TRACE_MASKF, PanelModelTaskPortal.this.traceId + " EventThread calls blocking valve.");
                        PanelModelTaskPortal.this.triggerManagerThreadBlockingValve.block();
                    }
                    catch (Exception e) {
                        Trace.trace(PanelModelTaskPortal.TRACE_MASKF, PanelModelTaskPortal.this.traceId + " an exception was thrown (and ignored) from blocking valve.");
                        Trace.trace(PanelModelTaskPortal.TRACE_MASKF, e);
                    }
                    finally {
                        Trace.trace(PanelModelTaskPortal.TRACE_MASKF, PanelModelTaskPortal.this.traceId + " EventThread proceeds, blocking valve returned.");
                    }
                }
                if (this.count == PanelModelTaskPortal.this.triggerThreadInvocationCount) {
                    Trace.trace(PanelModelTaskPortal.TRACE_MASKF, PanelModelTaskPortal.this.traceId + " EventThread calling releaseTriggerManagerThread().");
                    PanelModelTaskPortal.this.releaseTriggerManagerThread();
                } else {
                    Trace.trace(PanelModelTaskPortal.TRACE_MASKF, PanelModelTaskPortal.this.traceId + " looks like another trigger manager came in (counts didn't match), not calling release.");
                }
                Trace.trace(PanelModelTaskPortal.TRACE_MASKF, PanelModelTaskPortal.this.traceId + " EventThread dies of natural causes.");
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                Object object = PanelModelTaskPortal.this.stackLock;
                synchronized (object) {
                    this.threadRunning = false;
                    PanelModelTaskPortal.this.stackLock.notifyAll();
                }
                throw throwable;
            }
            Object object = PanelModelTaskPortal.this.stackLock;
            synchronized (object) {
                this.threadRunning = false;
                PanelModelTaskPortal.this.stackLock.notifyAll();
            }
        }

        public String toString() {
            return "PortalEventThread instance: running='" + this.threadRunning + "', activeModel='" + this.activeModel + "'";
        }
    }

    class RefreshTask
    extends TimerTask {
        private PanelModel initiator = null;

        RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Trace.trace(PanelModelTaskPortal.TRACE_MASKF, PanelModelTaskPortal.this.traceId + " RefreshTask pops, calling refresh().");
            PanelModelTaskPortal panelModelTaskPortal = PanelModelTaskPortal.this;
            synchronized (panelModelTaskPortal) {
                PanelModelTaskPortal.this.refreshTask = null;
            }
            PanelModelTaskPortal.this.refresh(this.initiator);
        }

        public boolean cancel() {
            Trace.trace(PanelModelTaskPortal.TRACE_MASKF, PanelModelTaskPortal.this.traceId + " RefreshTask canceled.");
            return super.cancel();
        }

        public void schedule(PanelModel initiator, int delay) {
            Trace.trace(PanelModelTaskPortal.TRACE_MASKF, PanelModelTaskPortal.this.traceId + " RefreshTask scheduling timer pop " + delay + "ms in future.");
            this.initiator = initiator;
            timer.schedule((TimerTask)this, delay);
        }
    }

    private static interface EventHandler {
        public void handle(PmTaskPortalLifeCycleListener var1, PmTaskPortalLifeCycleEvent var2);
    }
}

